package products;

import structure.device.Heater;
import structure.device.Light;
import structure.device.Shutter;
import structure.location.Floor;
import structure.location.House;
import structure.location.Room;

public class SantiagoHouse extends House {
	public SantiagoHouse() {
		layout();
	}

	protected void layout() {
		Floor floor = new Floor();
		Room living = new Room();
		living.addShutter(new Shutter("[NantesHouse]living.shutter"));
		living.addLight(new Light("[NantesHouse]living.light"));
		living.addHeater(new Heater("[NantesHouse]living.heater"));
		floor.addRoom(living);
		Room dorm = new Room();
		dorm.addShutter(new Shutter("[NantesHouse]dorm.shutter"));
		dorm.addLight(new Light("[NantesHouse]form.light"));
		addFloor(floor);
	}
}
